/*
 * Decompiled with CFR 0.152.
 */
package WebseitenPfadGenerator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileNode
implements Comparable<FileNode> {
    private File file;
    private List<FileNode> children;

    public FileNode(File file) {
        this.file = file;
        this.children = new ArrayList<FileNode>();
    }

    public File getFile() {
        return this.file;
    }

    public List<FileNode> getChildren() {
        return this.children;
    }

    public void addChild(FileNode child) {
        this.children.add(child);
        Collections.sort(this.children);
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public String toString() {
        return this.file.getName();
    }

    @Override
    public int compareTo(FileNode other) {
        if (this.isDirectory() && !other.isDirectory()) {
            return -1;
        }
        if (!this.isDirectory() && other.isDirectory()) {
            return 1;
        }
        return this.getName().compareToIgnoreCase(other.getName());
    }
}

